<?php
/**
 * Monitorio - Standalone Cron Runner
 * 
 * Usage: php cron-runner.php <cron_key>
 * Example: * * * * * /usr/bin/php /path/to/wp-content/plugins/monitorio/cron-runner.php YOUR_CRON_KEY
 */

// Only CLI
if (php_sapi_name() !== 'cli') {
    exit('This script can only be run from command line');
}

// Check arguments
if (!isset($argv[1])) {
    exit('Usage: php cron-runner.php <cron_key>');
}

$provided_key = $argv[1];

// Find WordPress
$wp_load_paths = array(
    dirname(__FILE__) . '/../../../wp-load.php',           // Standard plugin location
    dirname(__FILE__) . '/../../../../wp-load.php',        // Alternative
    '/var/www/html/wp-load.php',                           // Common location
    '/home/www/wp-load.php',                               // Alternative
);

$wp_loaded = false;
foreach ($wp_load_paths as $path) {
    if (file_exists($path)) {
        require_once($path);
        $wp_loaded = true;
        break;
    }
}

if (!$wp_loaded) {
    exit('Error: WordPress not found. Please check the script location.');
}

// Verify cron key
$stored_key = get_option('monitorio_cron_key');

if ($provided_key !== $stored_key) {
    exit('Error: Invalid cron key');
}

// Run monitoring
$plugin_path = dirname(__FILE__) . '/';
$script_path = $plugin_path . 'monitorio.php';
$config_path = $plugin_path . 'monitorio.cfg';

if (!file_exists($script_path)) {
    exit('Error: monitorio.php not found. Please download scripts from Monitorio.eu first.');
}

if (!file_exists($config_path)) {
    exit('Error: monitorio.cfg not found. Please configure the plugin first.');
}

try {
    // Include monitorio script
    include_once($script_path);
    
    if (class_exists('Monitorio')) {
        $monitorio = new Monitorio($config_path);
        $monitorio->testServer();
        
        // Update WordPress options
        $tz = new DateTimeZone('Europe/Bratislava');
        $now = new DateTime('now', $tz);
        update_option('monitorio_last_run', $now->format('Y-m-d H:i:s'));
        update_option('monitorio_run_count', intval(get_option('monitorio_run_count', 0)) + 1);
        
        echo "Success: Monitoring completed at " . current_time('mysql') . "\n";
        exit(0);
    } else {
        echo "Error: Monitorio class not found\n";
        exit(1);
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    error_log('Monitorio cron error: ' . $e->getMessage());
    exit(1);
}